/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Text.RegularExpressions;
using DataAccess;
using Ext.Net;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "BSMASTER")]

public partial class MasterPageExt : BaseMaster
{
    public string strMenuItems;
    public string strToolbarItems;
    

    //common objects
    protected CUser usr = new CUser();
    protected CDataUtils utils = new CDataUtils();

    //show the patient lookup popup
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void ShowPatLookup()
    {
        ucPatLookup.Show();
    }

    //show the timeout warning popup
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    ///<summary>
    ///US:7313 show the timeout warning popup
    /// </summary>
    /// <param name="strCPAID"></param>
    public void ShowTimeoutWarning()
    {
        winTimeoutWarning.Show();
    }

    //show the timeout warning popup
    [DirectMethod(ShowMask = false)]
    ///<summary>
    ///US:7313 Keep MDWS alive during timer updates
    /// </summary>
    /// <param name="strCPAID"></param>
    public void KeepMDWSAlive()
    {
        //prevent multiple calls
        if (Session["PING_MDWS"] != null)
        {
            return;
        }

        Session["PING_MDWS"] = "1";
       
        PingMDWS();

        Session["PING_MDWS"] = null;
    }

    //cancel the timeout
    [DirectMethod(ShowMask = false)]
    ///<summary>
    ///US:7313 cancel timeout
    /// </summary>
    /// <param name="strCPAID"></param>
    public void CancelTimeout()
    {
        //stop all tasks
        tmMain.StopAll();

        //set the label text
        lblAppMainTimer.Text = "16";

        //hide the timeout
        winTimeoutWarning.Hide();

        //stop the timer
        tmMain.StartAll();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    ///<summary>
    ///US:7313 timeout logg off
    /// </summary>
    /// <param name="strCPAID"></param>
    public void TimeoutLogoff()
    {
        //set the label text
        lblAppMainTimer.Text = "0";

        //stop all tasks
        tmMain.StopAll();

        winTimeoutWarning.Hide();

        //from direct method so call EXT version
        EXTLogOff();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    ///<summary>
    ///US:6246 US:6440 cache the selected cpa id if the user selects a CPA
    /// </summary>
    /// <param name="strCPAID"></param>
    public void OnCPAChange(string strCPAID)
    {
        if (strCPAID != "")
        {
            //cache the selected cpaid
            SelectedCPAID = strCPAID;
        }
    }

    /// <summary>
    /// US:6246 US:6440 US:6245 US:5349 Page Load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        litCPA.Text = SelectedCPAText + "&nbsp;";

        //THEME was here
        if (Theme508)
        {
            //ResourceManager1.Theme = Theme.Aria;
        }
        if (ThemeNone)
        {
            ResourceManager1.Theme = Theme.None;
        }
        if (ThemeDefault)
        {
            ResourceManager1.Theme = Theme.Default;
        }



        litStyleSheet.Text = "<link href=\"" + Page.ResolveUrl("~/css/jquery-ui-1.8.16.custom.css") + "\" rel=\"stylesheet\" type=\"text/css\" />";
        litStyleSheet.Text += "<link href=\"" + Page.ResolveUrl("~/css/ExtDDMenu.css") + "\" rel=\"stylesheet\" type=\"text/css\" />";
        litStyleSheet.Text += "<link href=\"" + Page.ResolveUrl("~/css/RevampStyleSheet.css") + "\" rel=\"stylesheet\" type=\"text/css\" />";

        litScripts.Text = "<script type=\"text/javascript\" src=\"" + Page.ResolveUrl("~/js/jquery-1.11.1.min.js") + "\" ></script>";
        litScripts.Text += "<script type=\"text/javascript\" src=\"" + Page.ResolveUrl("~/js/jquery-migrate-1.2.1.min.js") + "\" ></script>";
        litScripts.Text += "<script type=\"text/javascript\" src=\"" + Page.ResolveUrl("~/js/jquery-ui.min.js") + "\" ></script>";
        litScripts.Text += "<script type=\"text/javascript\" src=\"" + Page.ResolveUrl("~/js/jquery.select-range.js") + "\" ></script>";

        if (!this.IsLoggedIn())
        {
            GotoLoginPage();
        }

        //pass the master to the popup
        ucPatLookup.BaseMstr = this;

        if (!this.IsLoggedIn())
        {
            this.ClosePatient();
        }

        //remove PATIENTNAME session variable if
        //not logged in and patient_id is empty
        if (!this.IsLoggedIn() || String.IsNullOrEmpty(this.SelectedPatientID))
        {
            Session["PATIENTNAME"] = null;
        }

        
        //------------------------------------------------------------------------------
        // IS POSTBACK
        //------------------------------------------------------------------------------
        #region isPostBack
        if (IsPostBack)
        {
            //get the postback control
            string strPostBackControl = Request.Params["__EVENTTARGET"];
            if (strPostBackControl != null)
            {

                #region PatientLookup
                //did we do a patient lookup?
                if (strPostBackControl.Equals("PATIENT_LOOKUP"))
                {
                    //get the patient id
                    string[] strArg = Request.Form["__EVENTARGUMENT"].Split('|');


                    //moved all code to a method so we can use it from multiple places
                    LookupPatient(false, strArg[0]);
                }
                #endregion

                //-- 2/22/2011 close currently looked up patient
                if (strPostBackControl.Equals("CLOSE_PATIENT"))
                {
                    this.SelectedPatientID = "";
                    this.LookupSearchCase = -1;

                    GotoHomePage();
                }
            }
        }
        #endregion

        #region ShowUsernameAndPatientDemographics
        if (this.IsLoggedIn())
        {
            //Name Of User Currently logged on.
            string strUserLoggedOn = String.Empty;
            if (Session["USERLOGGEDON"] == null)
            {
                //not valid, we login to MDWS
                //strUserLoggedOn += "<img alt=\"Account Activity\" src=\"" + 
                //                    Page.ResolveUrl("~/Images/information.png") + 
                //                    "\" style=\"cursor: pointer; vertical-align: middle; margin-right: 3px;\" onclick=\"showAccDetails();\" />";
                
                strUserLoggedOn += UserLoggedOn();
                strUserLoggedOn += " - ";
                strUserLoggedOn += DateTime.Now.ToShortDateString();
                strUserLoggedOn += " ";
                strUserLoggedOn += DateTime.Now.ToShortTimeString();
                lblUserLoggedOn.Text = strUserLoggedOn;
                Session["USERLOGGEDON"] = strUserLoggedOn;
            }
            else
            {
                lblUserLoggedOn.Text = Session["USERLOGGEDON"].ToString();
            }

            //draw the patient info bar at the top

            //GET PATIENT NAME for the demographics blurb
            //Render Left Vertical Menu for selected patient
            if (this.IsLoggedIn())
            {
                if (!String.IsNullOrEmpty(this.SelectedPatientID)) //must be logged in too... 
                {
                    if (Session["PATIENTNAME"] == null)
                    {
                        CPatient cpat = new CPatient();
                        Session["PATIENTNAME"] = cpat.GetPatientDemoBlurb(this);
                    }
                    string[] strPatInfo = (string[])Session["PATIENTNAME"];

                    pnlDemoInfo.Show();
                    pnlDemoInfo.Html = "<span style=\"font-weight: bold;\">" + strPatInfo[0] + "</span>";

                }
                else
                {
                    pnlDemoInfo.Hide();
                    pnlDemoInfo.Html = String.Empty;
                }
            }
            else
            {
                pnlDemoInfo.Hide();
                pnlDemoInfo.Html = String.Empty;
            }
        }
        #endregion


        if (!this.IsLoggedIn())
        {
            pnlLogoff.Visible = false;
        }
        else
        {
            pnlLogoff.Visible = true;
        }

        //get account activity details
        //this is not valid for this app, we login to MDWS
        //GetAccountDetails();
        
        // Build the Menu & Toolbar HTML string
        BuildMenu();

        if (this.IsLoggedIn())
        {
            //debug only
            litdebug.Text = "";// "<font size=\"-2\">" + this.SiteID.ToString() + " " + this.DUZ + " " + this.DFN + "</font>";

            //load the users list of clinical program areas if full post back
            if (!X.IsAjaxRequest)
            {
                /*CCPA cpa = new CCPA();
                DataSet dsCPA = cpa.GetUserCPADS(this);
                CDataConverter cdc = new CDataConverter();
                string strCPAJson = cdc.GetJsonDSString(dsCPA);
                storMasterCPA.SetDataFromJson(strCPAJson);

                //now select the item
                if (SelectedCPAID > 0)
                {
                    cboMasterCPA.SelectedItem.Value = Convert.ToString(SelectedCPAID);
                }*/
            }
        }

        string strISEMsg = "Please review the highlighted field(s) for the following issues:<br/><ul>" +
                           "<li>The application will not accept a less-than symbol (<) followed by a letter. This can be corrected by adding a space between the symbol and the letter, e.g., \"< score\".</li>" +
                           "<li>The application will not accept an ampersand (&) followed by a hash sign (#). This can also be corrected by adding a space between the two symbols, i.e., \"& #\".</li></ul>";
        pnlISEMsg.Html = String.Format("<span>{0}</span>", strISEMsg);

        // ############################################
        // RE CALCULATE THE EXT.NET LAYOUTS
        //
        //EXT 3.1 DoComponentLayout does not exisit
        pnlNewWrk.UpdateLayout();
        pnlMainWorkspace.UpdateLayout();
        vpMasterViewport.DoLayout();
        //
        // ############################################

        if (this.DBConn.AuditFailed)
        {
            ShowSystemFeedback("A serious error occurred during the last system audit. Audit failure and incomplete audit trails present critical security issues. Please contact the System Administrator with this information as soon as possible.", "Audit Failed");
            this.DBConn.AuditFailed = false;
        }

    }

    //build menus and toolbar
    protected void BuildMenu()
    {
        //load the menu
        if (!X.IsAjaxRequest)
        {
            CAppMenu2 menu2 = new CAppMenu2(this, this.Page, 1);
            menu2.RenderToolbar(pnlMMenu);
            
            strToolbarItems = Regex.Replace(menu2.RenderToolbarHTML(), "href=\"(.*\\S)\"", "href=\"" + ResolveUrl("~/$1") + "\"", RegexOptions.IgnoreCase);
            strToolbarItems = Regex.Replace(strToolbarItems, "src=\"(.*\\S)\"", "src=\"" + ResolveUrl("~/$1") + "\"", RegexOptions.IgnoreCase);
            strToolbarItems = strToolbarItems.Replace("href=\"" + ResolveUrl("~/#") + "\"", "href=\"#\"");

        }
                
       // CAppMenu menu = new CAppMenu(this);
        //strMenuItems = Regex.Replace(menu.RenderMenuHTML(), "href=\"(.*\\S)\"", "href=\"" + ResolveUrl("~/$1") + "\"", RegexOptions.IgnoreCase);
        //strMenuItems = strMenuItems.Replace("href=\"" + ResolveUrl("~/#") + "\"", "href=\"#\"");

        //strToolbarItems = menu.RenderToolbarHTML();
    //    strToolbarItems = Regex.Replace(menu.RenderToolbarHTML(), "href=\"(.*\\S)\"", "href=\"" + ResolveUrl("~/$1") + "\"", RegexOptions.IgnoreCase);
    //    strToolbarItems = Regex.Replace(strToolbarItems, "src=\"(.*\\S)\"", "src=\"" + ResolveUrl("~/$1") + "\"", RegexOptions.IgnoreCase);
    //    strToolbarItems = strToolbarItems.Replace("href=\"" + ResolveUrl("~/#") + "\"", "href=\"#\"");

    }

    protected string UserLoggedOn()
    {
        string strUserName = "";
        CDataUtils utils = new CDataUtils();


        if (this.APPMaster.UserType == (long)(SUATUserType.PATIENT))
        {
            CPatient pat = new CPatient();

            //attempt to grab the user's profile
            strUserName = pat.GetPatientUserName(this);
        }
        else
        {
            CUserAdmin RevampUser = new CUserAdmin();
            DataSet dsRevampUser = new DataSet();
            //attempt to grab the user's profile
            dsRevampUser = RevampUser.GetSuatUserNameDS(this);

            //load SUAT User Name Name Field
            if (dsRevampUser != null)
            {
                foreach (DataTable table0 in dsRevampUser.Tables)
                {
                    foreach (DataRow row in table0.Rows)
                    {
                        if (!row.IsNull("NAME"))
                        {
                            strUserName = row["NAME"].ToString();
                        }

                        if (!row.IsNull("DIMS_ID"))
                        {
                            this.APPMaster.UserDMISID = row["DIMS_ID"].ToString();
                        }
                    }
                }
            }
        }
        return strUserName;
    }

    protected void btnKeepAlive_OnClick(object sender, EventArgs e)
    {
        string strValue = "";
        if (this.GetSessionValue("FX_USER_ID", out strValue))
        {
            Session["SESSION_INITIATED"] = DateTime.Now;
        }
        else
        {
            this.LogOff();
        }
    }

    protected void GetAccountDetails()
    {
        #region account_details
        if (this.IsLoggedIn() && Session["ACC_DETAILS"] == null)
        {
            CUser user = new CUser();
            DataSet dsUser = user.GetLoginUserDS(this, this.FXUserID);
            if (dsUser != null)
            {
                CDataUtils utils = new CDataUtils();
                string strAccDetails = String.Empty;

                DateTime dtLastLogin = utils.GetDSDateTimeValue(dsUser, "date_last_login");
                string strLastLogin = utils.GetDateTimeAsString(dtLastLogin);
                string strLastLoginIP = utils.GetDSStringValue(dsUser, "last_login_ip");

                DateTime dtFLastLogin = utils.GetDSDateTimeValue(dsUser, "last_flogin_date");
                string strFLastLogin = utils.GetDateTimeAsString(dtFLastLogin);
                string strFLastLoginIP = utils.GetDSStringValue(dsUser, "last_flogin_ip");

                long lFAttempts = utils.GetDSLongValue(dsUser, "flogin_attempts");
                string strFAttempts = Convert.ToString(lFAttempts);

                strAccDetails += "Unsuccessful Logon Attempts Since Last Successful Logon: " + strFAttempts;
                strAccDetails += "<br>";
                if (!String.IsNullOrEmpty(strFLastLoginIP))
                {
                    strAccDetails += "Last Unsuccessful Logon:";
                    strAccDetails += " " + strFLastLogin;
                    strAccDetails += " - IP Address: " + strFLastLoginIP;
                }
                else
                {
                    strAccDetails += "No Unsuccessful Logons";
                }

                strAccDetails += "<br>";
                strAccDetails += "Last Successful Logon:";
                strAccDetails += " " + strLastLogin;
                strAccDetails += " - IP Address: " + strLastLoginIP;

                Session["ACC_DETAILS"] = strAccDetails;
            }

            if (this.APPMaster.PasswordExpires > 0 && this.APPMaster.PasswordExpires <= 10)
            {
                this.StatusCode = 1;
                this.StatusComment = "Your account password will expire in " + Convert.ToString(this.APPMaster.PasswordExpires) + " days!";
            }
        }
        #endregion
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:5729 US:5716 US:5349
    /// public method to lookup a patient by patient id
    /// </summary>
    public void LookupPatient(bool bEXT, string strPatientID)
    {
        //Clears previously looked up patient id, treatment id
        this.SelectedPatientID = "";
        this.ClosePatient();

        //pass the patient id to the base, this will cache
        //it in the db fx_session_value table
        this.SelectedPatientID = strPatientID;

        //apply the default pathway for this patient (if neded)
        CCPA cpa = new CCPA();
        cpa.ApplyDefaultPathway(this, this.SelectedPatientID);


        //------------------------------------------------------------------------------
        //GET PATIENT NAME FOR THE DEMOGRAPHICS BLURB
        if (this.IsLoggedIn() && !String.IsNullOrEmpty(this.SelectedPatientID))//must be logged in too... 
        {

            if (Session["PATIENTNAME"] == null)
            {
                CPatient cpat = new CPatient();
                Session["PATIENTNAME"] = cpat.GetPatientDemoBlurb(this);
            }

            //GET SELECTED PATIENT'S DEMOGRAPHICS
            CPatient pat = new CPatient();
            CDataUtils utils = new CDataUtils();
            DataSet clientDemographics = new DataSet();

            Session["PAT_DEMOGRAPHICS_DS"] = pat.GetPatientDemographicsDS(this);
            clientDemographics = (DataSet)Session["PAT_DEMOGRAPHICS_DS"];

            foreach (DataTable patTable in clientDemographics.Tables)
            {
                foreach (DataRow patRow in patTable.Rows)
                {
                    //set the DFN
                    this.DFN = Convert.ToString(patRow["DFN"]);
                }
            }

            //select the patient in MDWS so that its the currently selected patient
            string strPatID = "";
            CMDWSOps opsPat = new CMDWSOps(this.GetDataObject());
            CStatus stat = opsPat.TransferPatientByDFN( this.Key,
                                                        this.DFN,
                                                        out strPatID);
        }

        //REDIRECT USER ------------------------------------------------------------------------
        long lSoapNoteUR = (long)SUATUserRight.NoteSubjectiveUR
            + (long)SUATUserRight.NoteObjectiveUR
            + (long)SUATUserRight.NoteAssessmentUR
            + (long)SUATUserRight.NotePlanUR;


        if (this.APPMaster.HasUserRight(lSoapNoteUR))
        {
            if (bEXT)
            {
                EXTGotoPatientSummaryPage();
            }
            else
            {
                GotoPatientSummaryPage();
            }
        }
        else if (this.APPMaster.HasUserRight((long)SUATUserRight.ProcessNewPatientsUR))
        {
            if (bEXT)
            {
                EXTGotoPatientDemographicsPage();
            }
            else
            {
                GotoPatientDemographicsPage();
            }
        }
        else
        {
            if (bEXT)
            {
                EXTGotoHomePage();
            }
            else
            {
                GotoHomePage();
            }
        }

    }

}